/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskTimePanel;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;

public class PASchedulerPanel
extends VWTaskTabPanel
implements ItemListener {
    JRadioButton rbCubeNever = null;
    JRadioButton rbCubeDailyTime = null;
    VWTaskTimePanel cubeDailyTime = null;
    JRadioButton rbCubeInterval = null;
    VWTaskNumericProperty cubeIntervalValue = null;
    JRadioButton rbPruneNever = null;
    JRadioButton rbPruneDailyTime = null;
    VWTaskTimePanel pruneDailyTime = null;

    public PASchedulerPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 23;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 0;
        this.add((Component)this.getCubeProcessingPanel(), c);
        c.insets = new Insets(10, 0, 0, 0);
        c.gridy = 1;
        this.add((Component)this.getPruneEventsPanel(), c);
        c.gridy = 2;
        c.weighty = 1.0;
        this.add(Box.createHorizontalStrut(0), c);
    }

    public void validateTextFields() throws VWException {
        super.validateTextFields();
        if (super.getValidationEnabled() && this.rbCubeInterval.isSelected()) {
            if (this.cubeIntervalValue.getText().trim().equals("")) {
                throw new VWException("vw.apps.taskman.pa.PAPropertyPanel.CubeProcIntervalMustBeSpecified", "A value must be entered for the cube processing interval.");
            }
            if (Integer.parseInt(this.cubeIntervalValue.getText().trim()) == 0) {
                throw new VWException("vw.apps.taskman.pa.PAPropertyPanel.CubeProcIntervalMustBeGreaterThanZero", "The cube processing interval value must be greater than zero.");
            }
        }
    }

    protected void applyProperties(Properties props) throws Exception {
        props.setProperty("analyzer.cubeprocessing.schedule.dailytime", "");
        props.setProperty("analyzer.cubeprocessing.schedule.byhours", "");
        props.setProperty("analyzer.cubeprocessing.schedule.byminutes", "");
        if (this.rbCubeDailyTime.isSelected()) {
            props.setProperty("analyzer.cubeprocessing.schedule.dailytime", this.cubeDailyTime.toString(1));
        } else if (this.rbCubeInterval.isSelected()) {
            props.setProperty("analyzer.cubeprocessing.schedule.byhours", this.cubeIntervalValue.getText().trim());
        }
        if (this.rbPruneDailyTime.isSelected()) {
            props.setProperty("analyzer.eventspruning.schedule.dailytime", this.pruneDailyTime.toString(1));
        } else {
            props.setProperty("analyzer.eventspruning.schedule.dailytime", "");
        }
    }

    protected void resetProperties(Properties props) throws Exception {
        if (!props.getProperty("analyzer.cubeprocessing.schedule.dailytime", "").equals("")) {
            this.rbCubeDailyTime.setSelected(true);
            this.cubeDailyTime.setTime(props.getProperty("analyzer.cubeprocessing.schedule.dailytime", "").trim(), 1);
        } else if (!props.getProperty("analyzer.cubeprocessing.schedule.byhours", "").equals("")) {
            this.rbCubeInterval.setSelected(true);
            this.cubeIntervalValue.setText(props.getProperty("analyzer.cubeprocessing.schedule.byhours", "").trim());
        } else {
            this.rbCubeNever.setSelected(true);
        }
        if (!props.getProperty("analyzer.eventspruning.schedule.dailytime", "").equals("")) {
            this.rbPruneDailyTime.setSelected(true);
            this.pruneDailyTime.setTime(props.getProperty("analyzer.eventspruning.schedule.dailytime", "").trim(), 1);
        } else {
            this.rbPruneNever.setSelected(true);
        }
        this.refreshControlState();
    }

    private VWToolbarBorder getCubeProcessingPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.CubeProcessing, 0, panel);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 23;
        c.insets = new Insets(10, 10, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        this.rbCubeNever = new JRadioButton(VWResource.Never);
        this.rbCubeNever.setBorder(null);
        this.rbCubeNever.addItemListener(this);
        panel.add((Component)this.rbCubeNever, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets.right = 5;
        panel.add(Box.createHorizontalStrut(1), c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        this.rbCubeDailyTime = new JRadioButton(VWResource.Daily);
        this.rbCubeDailyTime.setBorder(null);
        this.rbCubeDailyTime.addItemListener(this);
        panel.add((Component)this.rbCubeDailyTime, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets.right = 5;
        this.cubeDailyTime = new VWTaskTimePanel(2);
        panel.add((Component)this.cubeDailyTime, c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        this.rbCubeInterval = new JRadioButton(VWResource.Interval + ":");
        this.rbCubeInterval.setBorder(null);
        this.rbCubeInterval.addItemListener(this);
        c.weightx = 0.0;
        c.insets.right = 5;
        this.cubeIntervalValue = new VWTaskNumericProperty("", "#####");
        c.weightx = 1.0;
        c.gridwidth = 0;
        panel.add(Box.createHorizontalStrut(1), c);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbCubeDailyTime);
        buttonGroup.add(this.rbCubeInterval);
        buttonGroup.add(this.rbCubeNever);
        return borderPanel;
    }

    private VWToolbarBorder getPruneEventsPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.PruneEvents, 0, panel);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 23;
        c.insets = new Insets(10, 10, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        this.rbPruneNever = new JRadioButton(VWResource.Never);
        this.rbPruneNever.setBorder(null);
        this.rbPruneNever.addItemListener(this);
        panel.add((Component)this.rbPruneNever, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets.right = 5;
        panel.add(Box.createHorizontalStrut(1), c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets.right = 5;
        this.rbPruneDailyTime = new JRadioButton(VWResource.Daily);
        this.rbPruneDailyTime.setBorder(null);
        this.rbPruneDailyTime.addItemListener(this);
        panel.add((Component)this.rbPruneDailyTime, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets.right = 5;
        this.pruneDailyTime = new VWTaskTimePanel(2);
        panel.add((Component)this.pruneDailyTime, c);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbPruneDailyTime);
        buttonGroup.add(this.rbPruneNever);
        return borderPanel;
    }

    private VWTaskTabPanel getIntervalPanel(VWTaskNumericProperty value, JLabel units) {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 10);
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        value.setColumns(4);
        panel.add((JTextComponent)value, (Object)c, false);
        c.weightx = 1.0;
        c.insets.right = 0;
        panel.add((Component)units, c);
        return panel;
    }

    private void refreshControlState() {
        this.cubeIntervalValue.setEditable(this.rbCubeInterval.isSelected());
        this.pruneDailyTime.setEnabled(this.rbPruneDailyTime.isSelected());
        this.cubeDailyTime.setEnabled(this.rbCubeDailyTime.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        this.refreshControlState();
    }

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:39:26  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }
}

